function r = unifrnd_fast(a,b,k,l)
%UNIFRND Random arrays from continuous uniform distribution.
%   R = UNIFRND(A,B) returns an array of random numbers chosen from the
%   continuous uniform distribution on the interval from A to B.  The size
%   of R is the common size of A and B if both are arrays.  If either
%   parameter is a scalar, the size of R is the size of the other
%   parameter.
%
%   R = UNIFRND(A,B,M,N,...) or R = UNIFRND(A,B,[M,N,...]) returns an
%   M-by-N-by-... array.
%
%   See also UNIFCDF, UNIFINV, UNIFPDF, UNIFSTAT, UNIDRND, RANDOM.

%   UNIFRND uses a linear transformation of standard uniform random values.

%   Copyright 1993-2004 The MathWorks, Inc. 
%   $Revision: 2.12.4.4 $  $Date: 2004/06/25 18:53:25 $

if nargin==2
    k=1; l=1;
end

% Avoid    a+(b-a)*rand   in case   a-b > realmax
a2 = a/2;
b2 = b/2;
mu1 = a2+b2;
sig = b2-a2;

r = mu1 + sig .* (2*rand([k,l])-1);

% Fill in elements corresponding to illegal parameter values
% if ~isscalar(a) || ~isscalar(b)
%     r(a > b) = NaN;
% elseif a > b
%     r(:) = NaN;
% end
